<?php

/*-------------------------------------------
  MAIAN MAIL v3.1
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: Configuration File
---------------------------------------------*/

/****************************************************************************************************************
*  IMPORTANT - READ FIRST                                                                                       *
*  Listed below are the configuration options for your website. Edit them carefully, ensuring that you do NOT   *
*  remove any semi colons OR anything that is displayed in CAPITAL letters. These are important to the program. *                                                                             *
*****************************************************************************************************************/

/*=====================================================================================
  1. DEFINE WEBSITE SETTINGS
     Specify your contact form preferences.
=======================================================================================*/


// Website Name
// Escape apostrophes. ie: \'
define('WEBSITE_NAME', '');

// Homepage URL
define('HOMEPAGE_URL', '');

// Path to where contact form is installed. NO trailing slash
// This is only important if the box trapper is enabled
define('FORM_PATH', '');

// E-Mail Address
define('EMAIL_ADDRESS', '');

// Form Name
define('FORM_TITLE', '');

// Send Auto Respond e-mail to visitor? 
// 1 = yes, 0 = no
define('AUTO_RESPONDER', 1);

// Language file
define('LANGFILE', 'arabic.php');

// Enable captcha
// 0 = Off, 1 = On
// Settings for the captcha are in the following file:
// classes/php-captcha.inc.php
define('ENABLE_CAPTCHA', 1);



/*===========================================================================
  2. DEFINE ERROR CHECKING
     For which fields do you want error checking to be enabled?
     0 = Off, 1 = On
=============================================================================*/


// Name Field
define('NAME_CHECK', 1);

// Subject Field
define('SUBJECT_CHECK', 1);

// E-Mail Field
define('EMAIL_CHECK', 1);

// Comments Field
define('COMMENTS_CHECK', 1);


/*=======================================================
  3. SMTP SETTINGS
     If enabled overwrites PHP mail function
     Note some servers require authentication for this
     to work. Added in v3.1
=========================================================*/


// Enable SMTP
// 0 = No, 1 = Yes
define('SMTP', 0);

// SMTP Host
define('SMTP_HOST', 'localhost');

// SMTP Username
define('SMTP_USER', '');

// SMTP Password
define('SMTP_PASS', '');

// SMTP Port
define('SMTP_PORT', 25);


/*==================================================================
  4. BOX TRAPPER SETTINGS
     If enabled, messages are stored on the server and require
     e-mail verification before being sent. Unsent messages are
     deleted after x amount of days. Added in v3.1
===================================================================*/


// Enable Box trapper
// 0 = No, 1 = Yes
define('BOXTRAPPER', 0);

// Specify text file name for whitelist (ie, approved e-mail addresses)
// This is auto generated the first time the system runs and should
// ideally be named something unique. You can manually add e-mail
// addresses to this file if you want to. Note that the system stores
// e-mails in this format:
//
// support[at]maianscriptworld[dot]co[dot]uk
//
// If adding manually, you can use actual address. Data is changed to
// prevent any bots from grabbing the addresses, but will still work.
// You should prevent search bots from accessing your 'boxtrapper'
// folder by using robots.txt, or .htaccess.
define('WHITELIST_FILE', 'whitelist.txt');

// Amount of time (in days) messages remain before being deleted.
// An auto cron runs in the background everytime someone accesses
// the form. If old messages are found, they are deleted.
define('DURATION', 3);

?>
